/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.StyleRun;
import org.python.indexer.Util;
import org.python.indexer.types.NModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Linker {
    private static final Pattern CONSTANT = Pattern.compile("[A-Z_][A-Z0-9_]*");
    private Map<String, List<StyleRun>> fileStyles = new HashMap<String, List<StyleRun>>();
    private File outDir;
    private String rootPath;

    public Linker(String string, File file) {
        this.rootPath = string;
        this.outDir = file;
    }

    public void findLinks(Indexer indexer) {
        for (NBinding nBinding : indexer.getBindings().values()) {
            this.addSemanticStyles(nBinding);
            this.processDefs(nBinding);
            this.processRefs(nBinding);
        }
    }

    public List<StyleRun> getStyles(String string) {
        return this.stylesForFile(string);
    }

    private List<StyleRun> stylesForFile(String string) {
        List<StyleRun> list = this.fileStyles.get(string);
        if (list == null) {
            list = new ArrayList<StyleRun>();
            this.fileStyles.put(string, list);
        }
        return list;
    }

    private void addFileStyle(String string, StyleRun styleRun) {
        this.stylesForFile(string).add(styleRun);
    }

    private void addSemanticStyles(NBinding nBinding) {
        Def def = nBinding.getSignatureNode();
        if (def == null || !def.isName()) {
            return;
        }
        boolean bl = CONSTANT.matcher(def.getName()).matches();
        switch (nBinding.getKind()) {
            case SCOPE: {
                if (!bl) break;
                this.addSemanticStyle(def, StyleRun.Type.CONSTANT);
                break;
            }
            case VARIABLE: {
                this.addSemanticStyle(def, bl ? StyleRun.Type.CONSTANT : StyleRun.Type.IDENTIFIER);
                break;
            }
            case PARAMETER: {
                this.addSemanticStyle(def, StyleRun.Type.PARAMETER);
                break;
            }
            case CLASS: {
                this.addSemanticStyle(def, StyleRun.Type.TYPE_NAME);
            }
        }
    }

    private void addSemanticStyle(Def def, StyleRun.Type type) {
        String string = def.getFile();
        if (string != null) {
            this.addFileStyle(string, new StyleRun(type, def.start(), def.length()));
        }
    }

    private void processDefs(NBinding nBinding) {
        Def def = nBinding.getSignatureNode();
        if (def == null || def.isURL()) {
            return;
        }
        StyleRun styleRun = new StyleRun(StyleRun.Type.ANCHOR, def.start(), def.length());
        styleRun.message = nBinding.getQname();
        styleRun.url = nBinding.getQname();
        this.addFileStyle(def.getFile(), styleRun);
    }

    private void processRefs(NBinding nBinding) {
        if (nBinding.hasRefs()) {
            for (Ref ref : nBinding.getRefs()) {
                this.processRef(ref, nBinding);
            }
        }
    }

    void processRef(Ref ref, NBinding nBinding) {
        String string = ref.getFile();
        StyleRun styleRun = new StyleRun(StyleRun.Type.LINK, ref.start(), ref.length());
        styleRun.message = nBinding.getQname();
        styleRun.url = this.toURL(nBinding, string);
        if (styleRun.url != null) {
            this.addFileStyle(string, styleRun);
        }
    }

    private String toURL(NBinding nBinding, String string) {
        Def def = nBinding.getSignatureNode();
        if (def == null) {
            return null;
        }
        if (nBinding.isBuiltin()) {
            return def.getURL();
        }
        if (def.isModule()) {
            return this.toModuleUrl(nBinding);
        }
        String string2 = "#" + nBinding.getQname();
        if (nBinding.getFirstFile().equals(string)) {
            return string2;
        }
        String string3 = def.getFile();
        try {
            String string4 = string3.substring(this.rootPath.length());
            return Util.joinPath(this.outDir.getAbsolutePath(), string4) + ".html" + string2;
        }
        catch (Exception exception) {
            System.err.println("path problem:  dest=" + string3 + ", root=" + this.rootPath + ": " + exception);
            return null;
        }
    }

    private String toModuleUrl(NBinding nBinding) {
        NModuleType nModuleType = nBinding.getType().follow().asModuleType();
        String string = nModuleType.getFile();
        if (!string.startsWith(this.rootPath)) {
            return "file://" + string;
        }
        String string2 = string.substring(this.rootPath.length());
        return Util.joinPath(this.outDir.getAbsolutePath(), string2) + ".html";
    }
}

